/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.property.integrator;

import filenet.vw.api.VWAttributeInfo;
import filenet.vw.api.VWSystemConfiguration;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.property.integrator.IVWComponentRegistrationListener;
import filenet.vw.toolkit.admin.property.integrator.VWComponentRegistrationItem;
import filenet.vw.toolkit.admin.property.integrator.VWComponentRegistrationListCellRenderer;
import filenet.vw.toolkit.admin.property.integrator.VWLibraryRegistrationPanel;
import filenet.vw.toolkit.admin.resources.VWResource;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

class VWConfigurationModuleRegistrationPanel
extends JPanel
implements ActionListener,
ListSelectionListener,
KeyListener,
IVWComponentRegistrationListener {
    private JTextField m_classEntryTextField = null;
    private JButton m_addButton = null;
    private JList m_classList = null;
    private JButton m_deleteButton = null;
    private Container m_parentContainer = null;
    private VWSystemConfiguration m_systemConfiguration = null;
    private VWLibraryRegistrationPanel m_vwLibraryRegistrationPanel = null;
    private boolean m_bIsModified = false;

    public VWConfigurationModuleRegistrationPanel(Container parentContainer, VWSystemConfiguration vwSystemConfiguration, VWLibraryRegistrationPanel vwLibraryRegistrationPanel) {
        try {
            this.m_parentContainer = parentContainer;
            this.m_systemConfiguration = vwSystemConfiguration;
            this.m_vwLibraryRegistrationPanel = vwLibraryRegistrationPanel;
            this.initLayout();
            this.loadConfigurationInformation();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void actionPerformed(ActionEvent event) {
        Object obj = event.getSource();
        if (obj.equals(this.m_addButton)) {
            String infoMsg;
            String className = this.m_classEntryTextField.getText();
            if (className != null) {
                className = className.trim();
            }
            if ((infoMsg = this.verifyClass(className, this.getCustomClassLoader())) == null) {
                VWComponentRegistrationItem aItem = new VWComponentRegistrationItem(className);
                this.addComponentRegistrationItem(aItem);
                this.m_classEntryTextField.setText("");
                this.m_bIsModified = true;
            } else {
                JOptionPane.showMessageDialog(this.m_parentContainer, infoMsg, VWResource.ErrorMessage, 0);
            }
        } else if (obj.equals(this.m_deleteButton)) {
            this.deleteSelectedItems(event);
        }
    }

    public void keyPressed(KeyEvent event) {
    }

    public void keyReleased(KeyEvent event) {
    }

    public void keyTyped(KeyEvent event) {
        this.setAddButtonState();
    }

    public void valueChanged(ListSelectionEvent event) {
        try {
            if (event.getValueIsAdjusting()) {
                return;
            }
            if (event.getSource().equals(this.m_classList)) {
                int[] nSelectedIndices = this.m_classList.getSelectedIndices();
                this.m_deleteButton.setEnabled(nSelectedIndices != null && nSelectedIndices.length > 0);
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void releaseResources() {
        if (this.m_classEntryTextField != null) {
            this.m_classEntryTextField.removeAll();
            this.m_classEntryTextField = null;
        }
        if (this.m_addButton != null) {
            this.m_addButton.removeActionListener(this);
            this.m_addButton.removeAll();
            this.m_addButton = null;
        }
        if (this.m_classList != null) {
            this.m_classList.removeAll();
            this.m_classList = null;
        }
        if (this.m_deleteButton != null) {
            this.m_deleteButton.removeActionListener(this);
            this.m_deleteButton.removeAll();
            this.m_deleteButton = null;
        }
        this.m_parentContainer = null;
        this.m_systemConfiguration = null;
        if (this.m_vwLibraryRegistrationPanel != null) {
            this.m_vwLibraryRegistrationPanel.releaseResources();
            this.m_vwLibraryRegistrationPanel = null;
        }
        this.removeAll();
    }

    public boolean validateComponentList() {
        boolean bOk = true;
        if (this.m_classList != null) {
            DefaultListModel listModel = (DefaultListModel)this.m_classList.getModel();
            int sz = listModel.size();
            for (int i = 0; i < sz; ++i) {
                VWComponentRegistrationItem aItem = (VWComponentRegistrationItem)listModel.getElementAt(i);
                if (aItem == null || aItem.isValid()) continue;
                bOk = false;
                break;
            }
        }
        return bOk;
    }

    public void refreshComponentList() {
        try {
            if (this.m_classList != null) {
                ClassLoader theClassLoader = this.getCustomClassLoader();
                DefaultListModel listModel = (DefaultListModel)this.m_classList.getModel();
                int sz = listModel.size();
                for (int i = 0; i < sz; ++i) {
                    VWComponentRegistrationItem aItem = (VWComponentRegistrationItem)listModel.getElementAt(i);
                    if (aItem == null) continue;
                    String infoMsg = this.verifyClass(aItem.getName(), theClassLoader);
                    aItem.setInfo(infoMsg);
                    aItem.setValid(infoMsg == null);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected boolean isModified() {
        return this.m_bIsModified;
    }

    protected Vector getConfigurationModuleClasses() {
        try {
            VWAttributeInfo attributeInfo;
            String configurationModules;
            Vector<String> classNames = new Vector<String>();
            if (this.m_systemConfiguration != null && (configurationModules = (String)(attributeInfo = this.m_systemConfiguration.getAttributeInfo()).getFieldValue("F_ConfigurationModules")) != null && configurationModules.length() > 0) {
                StringTokenizer st = new StringTokenizer(configurationModules, ",");
                while (st.hasMoreTokens()) {
                    classNames.addElement(st.nextToken().trim());
                }
            }
            return classNames;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            return null;
        }
    }

    protected ClassLoader getCustomClassLoader() {
        String[] libraries;
        if (this.m_vwLibraryRegistrationPanel != null && (libraries = this.m_vwLibraryRegistrationPanel.getLibraries()) != null && libraries.length > 0) {
            Vector<URL> availableLibraries = new Vector<URL>();
            for (int i = 0; i < libraries.length; ++i) {
                try {
                    File jarFile = new File(libraries[i].trim());
                    URL tempURL = jarFile.toURL();
                    availableLibraries.addElement(tempURL);
                    continue;
                }
                catch (Exception ex) {
                    VWDebug.logException(ex);
                }
            }
            if (availableLibraries.size() > 0) {
                Object[] urls = new URL[availableLibraries.size()];
                availableLibraries.copyInto(urls);
                return new URLClassLoader((URL[])urls, this.getClass().getClassLoader());
            }
        }
        return this.getClass().getClassLoader();
    }

    protected boolean save() {
        return this.saveConfigurationInformation();
    }

    private void initLayout() {
        try {
            this.setBorder(BorderFactory.createEmptyBorder(6, 6, 6, 6));
            this.setLayout(new BorderLayout());
            VWToolbarBorder tbBorder = new VWToolbarBorder(VWResource.EnterClassName);
            JPanel clientPanel = tbBorder.getClientPanel();
            clientPanel.setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridwidth = 1;
            gbCons.gridheight = 1;
            gbCons.anchor = 23;
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(2, 0, 0, 6);
            this.m_classEntryTextField = new JTextField();
            this.m_classEntryTextField.addKeyListener(this);
            clientPanel.add((Component)this.m_classEntryTextField, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            this.m_addButton = new JButton(VWResource.Add);
            this.m_addButton.setEnabled(false);
            this.m_addButton.addActionListener(this);
            clientPanel.add((Component)this.m_addButton, gbCons);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.fill = 1;
            gbCons.weightx = 1.0;
            gbCons.weighty = 1.0;
            gbCons.insets = new Insets(4, 0, 0, 6);
            this.m_classList = new JList(new DefaultListModel());
            this.m_classList.addListSelectionListener(this);
            this.m_classList.setCellRenderer(new VWComponentRegistrationListCellRenderer());
            clientPanel.add((Component)this.m_classList, gbCons);
            ++gbCons.gridx;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            this.m_deleteButton = new JButton(VWResource.Delete);
            this.m_deleteButton.setEnabled(false);
            this.m_deleteButton.addActionListener(this);
            clientPanel.add((Component)this.m_deleteButton, gbCons);
            this.add((Component)tbBorder, "Center");
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void loadConfigurationInformation() {
        try {
            Vector classNames = this.getConfigurationModuleClasses();
            if (classNames != null && classNames.size() > 0) {
                ClassLoader theClassLoader = this.getCustomClassLoader();
                for (int i = 0; i < classNames.size(); ++i) {
                    String theClassName = (String)classNames.elementAt(i);
                    String infoMsg = this.verifyClass(theClassName, theClassLoader);
                    VWComponentRegistrationItem aItem = new VWComponentRegistrationItem(theClassName);
                    if (infoMsg != null) {
                        aItem.setInfo(infoMsg);
                        aItem.setValid(false);
                    }
                    this.addComponentRegistrationItem(aItem);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private boolean saveConfigurationInformation() {
        try {
            if (this.m_systemConfiguration != null && this.m_classList != null) {
                StringBuffer attributeString = new StringBuffer();
                DefaultListModel listModel = (DefaultListModel)this.m_classList.getModel();
                for (int i = 0; i < listModel.size(); ++i) {
                    VWComponentRegistrationItem aElem;
                    if (i > 0) {
                        attributeString.append(", ");
                    }
                    if ((aElem = (VWComponentRegistrationItem)listModel.getElementAt(i)) == null) continue;
                    attributeString.append(aElem.getName());
                }
                VWAttributeInfo attributeInfo = this.m_systemConfiguration.getAttributeInfo();
                attributeInfo.setFieldValue("F_ConfigurationModules", attributeString.toString());
                this.m_systemConfiguration.setAttributeInfo(attributeInfo);
            }
            return true;
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            String message = ex.getLocalizedMessage();
            if (message == null || message != null && message.length() == 0) {
                message = ex.toString();
            }
            JOptionPane.showMessageDialog(this.m_parentContainer, message, VWResource.ErrorMessage, 0);
            return false;
        }
    }

    private String verifyClass(String className, ClassLoader classLoader) {
        String retMsg;
        block8: {
            retMsg = null;
            try {
                if (className != null && classLoader != null) {
                    Class<?> importClass;
                    if ((className = className.replace('/', '.')).endsWith(".class")) {
                        className = className.substring(0, className.length() - 6);
                    }
                    if ((importClass = classLoader.loadClass(className)) != null) {
                        boolean bFound = false;
                        Class<?>[] interfaces = importClass.getInterfaces();
                        for (int i = 0; i < interfaces.length; ++i) {
                            if (!interfaces[i].getName().equals("filenet.vw.integrator.IVWComponentConfiguration")) continue;
                            bFound = true;
                            break;
                        }
                        if (!bFound) {
                            retMsg = VWResource.ClassDoesNotImplementInterface.toString(className, "IVWComponentConfiguration");
                        }
                    }
                }
            }
            catch (ClassNotFoundException ex) {
                retMsg = VWResource.ClassNotFound.toString(className);
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
                retMsg = ex.getLocalizedMessage();
                if (retMsg != null && (retMsg == null || retMsg.length() != 0)) break block8;
                retMsg = ex.toString();
            }
        }
        return retMsg;
    }

    private void addComponentRegistrationItem(VWComponentRegistrationItem aItem) {
        if (this.m_classList != null) {
            DefaultListModel listModel = (DefaultListModel)this.m_classList.getModel();
            listModel.addElement(aItem);
        }
    }

    private void deleteSelectedItems(ActionEvent event) {
        if (this.m_classList != null) {
            DefaultListModel listModel = (DefaultListModel)this.m_classList.getModel();
            int[] nSelectedIndices = this.m_classList.getSelectedIndices();
            if (nSelectedIndices != null && nSelectedIndices.length > 0) {
                for (int i = nSelectedIndices.length - 1; i >= 0; --i) {
                    listModel.removeElementAt(nSelectedIndices[i]);
                }
                this.m_bIsModified = true;
            }
        }
    }

    private void setAddButtonState() {
        String tempString;
        if (this.m_addButton == null) {
            return;
        }
        boolean bEnable = false;
        if (this.m_classEntryTextField != null && (tempString = this.m_classEntryTextField.getText()) != null && tempString.trim().length() > 0) {
            bEnable = true;
        }
        this.m_addButton.setEnabled(bEnable);
    }
}

